'use strict';

const xid = require('xid-js');
const axios = require('axios');
const { alipaySdk, returnUrl, notifyUrl, formatAndValidateExpiredAt} = require("../utils/common");

exports.main = async function (event, context) {
  const req = JSON.parse(event.body);
  const {totalAmount, subject, productSlug, productName, personaId, expiredAt} = req;

  console.log('totalAmount:', totalAmount);
  console.log('subject:', subject);
  console.log('productSlug:', productSlug);
  console.log('productName:', productName);

  if (!Number.isInteger(totalAmount) || totalAmount === 0) {
    console.log('Variable totalAmount is not an integer bigger than 0:', totalAmount);
    return {
      statusCode: 400,
      headers: {"Content-Type":"application/json"},
      body: "invalid totalAmount. Should be an integer bigger than 0.",
    };
  }

  const outTradeNo = xid.next();
  console.log('outTradeNo:', outTradeNo);

  const totalAmountYuan = (totalAmount/100).toFixed(2);
  console.log('totalAmount in Yuan:', totalAmountYuan);

  const result = formatAndValidateExpiredAt(expiredAt);
  if (result.error) {
    return result.error;
  }

  const bizContent = {
    out_trade_no: outTradeNo,
    total_amount: totalAmountYuan,
    subject: subject,
    product_code: "QUICK_WAP_WAY",
    time_expire: result.formattedDate,
    goods_detail: [{
      goods_id: productSlug,
      goods_name: productName,
      quantity: "1",
      price: totalAmount,
    }],
  };

  const url = alipaySdk.pageExecute('alipay.trade.wap.pay', 'GET', {
    bizContent,
    notifyUrl: notifyUrl,
    returnUrl: returnUrl
  });

  const {UOS_APP_ID, UOS_APP_SERVICE_SECRET} = process.env;

  try {
    const response = await axios.post('https://p.unity.cn/v1/payments', {
      personaId: personaId,
      outTradeNo: outTradeNo,
      paymentMethod: "alipay.trade.wap.pay",
      totalAmount: totalAmount,
      productSlug: productSlug,
      expiredAt: expiredAt
    }, {
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Basic ' + btoa(UOS_APP_ID + ':' + UOS_APP_SERVICE_SECRET)
      }
    });

  } catch (err) {
    console.error(err);
    return {
      statusCode: 400,
      headers: {"Content-Type":"application/json"},
      body: JSON.stringify(err.response.data),
    };
  }

  return {
    statusCode: 200,
    headers: {"Content-Type":"text/html"},
    body: url,
  };
};